<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$message = "";

// Fetch patients
$patientQuery = $con->prepare("SELECT id, fullName FROM users ORDER BY fullName");
$patientQuery->execute();
$patientResult = $patientQuery->get_result();

// Handle form submission
if (isset($_POST['submit'])) {
    $patient_id   = intval($_POST['patient_id']);
    $weight       = floatval($_POST['weight']);
    $height       = floatval($_POST['height']);
    $temperature  = floatval($_POST['temperature']);
    $blood_pressure = trim($_POST['blood_pressure']);

    $stmt = $con->prepare("INSERT INTO patient_vitals (patient_id, weight, height, temperature, blood_pressure) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("iddds", $patient_id, $weight, $height, $temperature, $blood_pressure);

    if ($stmt->execute()) {
        $message = "✅ Patient vitals added successfully!";
    } else {
        $message = "❌ Error: " . $con->error;
    }
}

// Optional: pre-select patient
$selectedPatient = isset($_GET['patient_id']) ? 
    $con->query("SELECT id as patient_id, fullName FROM users WHERE id=" . intval($_GET['patient_id']))->fetch_assoc() : null;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add Patient Vitals</title>
<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-4">
    <h3>Add Patient Details / Vitals</h3>

    <?php if ($message): ?>
        <div class="alert alert-info"><?= htmlentities($message) ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="row">
            <div class="col-md-6">
                <label class="form-label">Patient</label>
                <?php if ($selectedPatient): ?>
                    <input type="hidden" name="patient_id" value="<?= $selectedPatient['patient_id'] ?>">
                    <input type="text" class="form-control" value="<?= htmlentities($selectedPatient['fullName']) ?>" readonly>
                <?php else: ?>
                    <select name="patient_id" class="form-control" required>
                        <option value="">-- Select Patient --</option>
                        <?php while ($row = $patientResult->fetch_assoc()) : ?>
                            <option value="<?= $row['id'] ?>"><?= htmlentities($row['fullName']) ?></option>
                        <?php endwhile; ?>
                    </select>
                <?php endif; ?>
            </div>

            <div class="col-md-6">
                <label class="form-label">Weight (kg)</label>
                <input type="number" step="0.1" name="weight" class="form-control" required>
            </div>

            <div class="col-md-6 mt-3">
                <label class="form-label">Height (cm)</label>
                <input type="number" step="0.1" name="height" class="form-control" required>
            </div>

            <div class="col-md-6 mt-3">
                <label class="form-label">Temperature (°C)</label>
                <input type="number" step="0.1" name="temperature" class="form-control" required>
            </div>

            <div class="col-md-6 mt-3">
                <label class="form-label">Blood Pressure</label>
                <input type="text" name="blood_pressure" class="form-control" placeholder="e.g., 120/80" required>
            </div>
        </div>

        <button type="submit" name="submit" class="btn btn-primary mt-3">Save Vitals</button>
    </form>
</div>
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
